﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;


/* Thread Local Storage (TLS) */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }

        SynchronizationContext synContext;

        void DataSlotThreadProc()
        {
            LocalDataStoreSlot slot = Thread.GetNamedDataSlot("Slot Value");
            Thread.SetData(slot, 1234);
            int x = (int)Thread.GetData(slot);

            string S = "Thread ID: " + Thread.CurrentThread.ManagedThreadId.ToString() +
                        ", Slot Value: " + x.ToString();

            synContext.Send(SynchronizedMethod, S);
        }

        [ThreadStatic()]
        static private int? tlsData;

        static private int TlsData
        {
            get { return (int?)tlsData ?? 0; }
            set { tlsData = value; }
        }

        void ThreadStaticFieldThreadProc()
        {
            TlsData++;

            string S = "Thread ID: " + Thread.CurrentThread.ManagedThreadId.ToString() +
            ", Thread static field value: " + TlsData.ToString();

            synContext.Send(SynchronizedMethod, S);
        }
 

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        } 

        private void btnDataSlot_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(DataSlotThreadProc);
            t.Start();
        } 

        private void btnThreadStaticField_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(ThreadStaticFieldThreadProc);
            t.Start();
        }
    }
}
 